using log4net;
using Microsoft.Azure.WebJobs;
using System;
using VA.PPMS.IWS.ProviderAgreementService.Interface;

namespace VA.PPMS.IWS.Functions
{
    public static class ProviderAgreementTimerTrigger
    {
        [FunctionName("ProviderAgreementTimerTrigger")]
        public static void Run([TimerTrigger("%ProviderAgreementTimerInterval%")] TimerInfo myTimer,
            [Inject] IProviderAgreementService providerAgreementService,
            [Inject] ILog logger)
        {
            try
            {
                //logger.Info($"Start ProviderAgreementTimerTrigger function at: {DateTime.Now}");

                providerAgreementService.ProcessData();

                //logger.Info($"End ProviderAgreementTimerTrigger at: {DateTime.Now}");
            }
            catch (Exception ex)
            {
                logger.Error($"There was a problem with ProviderAgreementTimerTrigger Processing at: {DateTime.Now}.", ex);
            }
        }
    }
}